clear all
close all
clc

%%% NOTES:

%%% 1. I put "pause" after each plot, you will have to press a random key to
%%%    continue each time (so you can see the traces before the script closes
%%%    the figure).

%%% 2. Useful commands that you can use: 
%%%     - pause: stops the script up to when you press a key
%%%     - close all: closes all the open figures
%%%     - clear all: clears all the variables in the workspace
%%%     - clearvars X Y: deletes the variables X and Y p(e.g. if you want to
%%%     run the same section of the script again, to avoid overlapping)
%%%     - clc: clears the command window, you can use it as a control
%%%     - two % in a row: they create a new session, insert if you want to
%%%     run just a part of the script


%% Reads Results.csv and divides it in nfiles called 'Results1.csv' etc

[celllabel,ncell,nfiles] = cutresultsfunction();

%% Changes name of 'ResultsX.csv' to 'Results.csv' and back upon click

renameresultsfunction(nfiles);

%% TIMETRACES  

%%% YOU NEED: nfiles, ncell, celllabel and various Results.csv
%%% It reads all TimeTraces.txt files and merges them in one matrix to plot

[timetraces,xaxis] = timeseriesmergefunction1(nfiles,ncell);

%% TIMETRACES AVERAGE AND STANDARD DEVIATION

%%% It creates average and stdev vectors for all ROIs analyzed (bulk population vs time) 

ii=0;
average = zeros(1,size(timetraces,1));
stdev = zeros(1,size(timetraces,1));

for ii=1:size(timetraces,1) %for all the frames
    
    average(ii) = mean(timetraces(ii,:));
    stdev(ii) = std(timetraces(ii,:));
    
end

clearvars ii ans

%% TIMETRACES SCATTER PLOT

%%% Creates the heat scatter plot of the raw timeseries

close all
heatscatterfunction(xaxis,ncell,timetraces,'Heat Scatter Plot (Raw Data).png','Time(s)','MFI');
pause

%%% Plots all the traces, and their average and standard deviation

close all
plotaveragefunction('MFI of single cells','MFI averaged on all cells','Time(s)','MFI','Time(s)','MFI',timetraces,xaxis,average,stdev)

save('workspace');
%% Allows you to select the traces to continue analysis with (you can skip)

%%% NB if you want to continue analyzing all the cells instead of the
%%% selected ones, move to the next section without running this one.

[selected,trashed,timetracesselected,timetracestrashed]= cellselectionfunction(xaxis,timetraces,celllabel);

celllabelALL = celllabel;
timetracesALL = timetraces;
clearvars celllabel timetraces;
celllabel = selected;
timetraces = timetracesselected;
clearvars selected timetracesselected;

%%% Plot selected cells' time traces and heatmap

plotheatmapfunction('Selected cells','Selected cells, heatmap','Time (s)','MFI','Frames','Stack of responders',timetraces,xaxis);


%% NORMALIZED TRACES, AVERAGE AND STANDARD DEVIATION

%%% YOU NEED: nfiles, ncell, celllabel, timetraces

%%% Converts to (MFI-MFI0)/MFI0*100 each ROI

ii=0;
jj=0;
ratiotimetraces=zeros(size(timetraces,1),size(timetraces,2));
for ii=1:size(timetraces,2) %for all the cells (columns)
    for jj=1:size(timetraces,1) %for all the frames (rows)
    ratiotimetraces(jj,ii)=(timetraces(jj,ii)-timetraces(1,ii))/timetraces(1,ii)*100;
    end
end
clearvars ii jj

%%% Creates average and stdev vectors of ratiotimetraces for all ROIs analyzed (bulk population vs time) 
 
jj=0;
ratioaverage = zeros(1,size(timetraces,1));
ratiostdev = zeros(1,size(timetraces,1));

    for jj=1:size(timetraces,1) % for all the frames (rows)
        
    ratioaverage(1,jj) = mean(ratiotimetraces(jj,:));
    ratiostdev(1,jj) = std(ratiotimetraces(jj,:));
    % ratiomode(jj) = mode(ratiotimetraces(jj,:));      % for the mode
    % ratiomedian(jj) = median(ratiotimetraces(jj,:));  % for the median
    
    end
    
clearvars jj

%%% Creates the heat scatter plot of the normalized timeseries

close all
heatscatterfunction(xaxis,size(timetraces,2),ratiotimetraces,'Heat Scatter Plot (Normalized Data).png','Time(s)','(MFI-MFI_{0})/MFI_{0}*100');
pause

%%% Plots all the traces, and their average and standard deviation

close all
plotaveragefunction('(MFI-MFI_{0})/MFI_{0}*100 of single cells','(MFI-MFI_{0})/MFI_{0}*100 averaged on all cells','Time(s)','(MFI-MFI_{0})/MFI_{0}*100','Time(s)','(MFI-MFI_{0})/MFI_{0}*100',ratiotimetraces,xaxis,ratioaverage,ratiostdev)
pause

%%% Plots all the normalized traces, their average and the average/mode/median

close all
figure('Name','Normalized MFI of single cells and bulk average','NumberTitle','off','Color',[1 1 1]); 

jj=0;
ii=0;
for ii=1:size(timetraces,2) 
    subplot(3,1,1);
    M(ii) = plot(xaxis,ratiotimetraces(:,ii));
    hold on
end
title('MFI/MFI_{0} of single cells','FontSize',18,'FontName','Optima');
xlabel('Time (s)','FontSize',18,'FontName','Optima');
ylabel('MFI/MFI_{0}','FontSize',18,'FontName','Optima');
xlim([min(xaxis) max(xaxis)]);
set(M, 'ButtonDownFcn', {@LineSelected, M});

subplot(3,1,3);
hold on
%LegendString1 = cell(1,['a' 's' 'd' 'f']);
plot(xaxis,ratioaverage,'b'); % plots the average
% hold on
% plot(xaxis,ratiomode,'g'); % plots the mode
% hold on
% plot(xaxis,ratiomedian,'r'); % plots the median
% hold on
% plot(xaxis,ratiotimetraces(:,6),'m'); % plots trace number 6 (modify number to find non-responsive reference cell)
% hold off
legend('Average','Mode','Median','One Trace');
xlim([min(xaxis) max(xaxis)]);

subplot(3,1,2);
shadedErrorBar(xaxis,ratioaverage,ratiostdev,'-b',1);
title('MFI/MFI_{0} averaged on all cells','FontSize',12);
xlabel('Time (s)','FontSize',10);
ylabel('MFI/MFI_{0}','FontSize',10);
xlim([min(xaxis) max(xaxis)]);

%%% saves figure

if(exist('figdir','var') == 1)
    saveFigs(figdir,'format','png','name','measurement');
else
    saveFigs('img','format','jpg','name','measurement');
end

clearvars ii jj ans M

pause
close all
save('workspace');

%% Allows you to select the traces to continue analysis with (you can skip)

%%% NB if you want to continue analyzing all the cells instead of the
%%% selected ones, comment the following lines 159 to 164

[ratioselected,ratiotrashed,ratiotimetracesselected,ratiotimetracestrashed]= cellselectionfunction(xaxis,ratiotimetraces,celllabel);

ratiocelllabelALL = celllabel;
ratiotimetracesALL = ratiotimetraces;
clearvars celllabel ratiotimetraces;
celllabel = ratioselected;
ratiotimetraces = ratiotimetracesselected;
clearvars ratioselected ratiotimetracesselected;

%%% Plot selected cells' time traces and heatmap

plotheatmapfunction('Selected cells','Selected cells, heatmap','Time (s)','MFI','Frames','Stack of responders',ratiotimetraces,xaxis);

%% CORRECTED TRACES

%%% Correction of photobleaching effect (adds at each point abs(ratioaverage))

ii=0;
jj=0;
corrtimetraces=zeros(size(ratiotimetraces,1),size(ratiotimetraces,2));

for ii=1:size(ratiotimetraces,2)
    for jj=1:size(ratiotimetraces,1)
    corrtimetraces(jj,ii)=ratiotimetraces(jj,ii)-ratioaverage(jj); %change to ratiomode(jj)/ratiomedian(jj)/ratiotimetraces(jj,6)
    end
end

clearvars ii jj ans

%%% Creates the heat scatter plot of the normalized timeseries

close all
heatscatterfunction(xaxis,size(ratiotimetraces,2),corrtimetraces,'Heat Scatter Plot (Corrected Data).png','Time(s)','(MFI-MFI_{0})/MFI_{0}*100');
pause

%%% Plots all the normalized traces and the corrected traces

close all
figure('Name','Normalized and Corrected','NumberTitle','off','Color',[1 1 1])
ii=0;
for ii=1:size(ratiotimetraces,2)
    subplot(2,1,1);
    M(ii) = plot(xaxis,ratiotimetraces(:,ii));
    hold on
end
title('(MFI-MFI_{0})/MFI_{0}*100 of single cells','FontSize',18,'FontName','Optima');
xlabel('Time (s)','FontSize',18,'FontName','Optima');
ylabel('(MFI-MFI_{0})/MFI_{0}*100','FontSize',18,'FontName','Optima');
xlim([min(xaxis) max(xaxis)]);
set(M, 'ButtonDownFcn', {@LineSelected, M});

%%% Plots corrected traces

ii=0;
for ii=1:size(ratiotimetraces,2)
    subplot(2,1,2);
    M(ii) = plot(xaxis,corrtimetraces(:,ii));
    hold on
end
title('Corrected (MFI-MFI_{0})/MFI_{0}*100','FontSize',18,'FontName','Optima');
xlabel('Time (s)','FontSize',18,'FontName','Optima');
ylabel('(MFI-MFI_{0})/MFI_{0}*100','FontSize',18,'FontName','Optima');
xlim([min(xaxis) max(xaxis)]);
set(M, 'ButtonDownFcn', {@LineSelected, M});

%%% Saves figure

if(exist('figdir','var') == 1)
    saveFigs(figdir,'format','png','name','measurement');
else
    saveFigs('img','format','jpg','name','measurement');
end

clearvars ii jj ans M

pause 
close all

save('workspace');

%% Allows you to select the traces to continue analysis with (better to select cells here I think)

%%% NB if you want to continue analyzing all the cells instead of the
%%% selected ones, comment the following lines 235 to 240

[corrselected,corrtrashed,corrtimetracesselected,corrtimetracestrashed]= cellselectionfunction(xaxis,corrtimetraces,celllabel);

corrcelllabelALL = celllabel;
corrtimetracesALL = corrtimetraces;
clearvars celllabel corrtimetraces;
celllabel = corrselected;
corrtimetraces = corrtimetracesselected;
clearvars corrselected corrtimetracesselected;

%%% Plot selected cells' time traces and heatmap

plotheatmapfunction('Selected cells','Selected cells, heatmap','Time (s)','MFI','Frames','Stack of responders',corrtimetraces,xaxis);

%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Plot corrected normalized averaged MFI in surface plot
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% corrnormtimetracest = corrnormtimetraces'; %%% Creates transposts for colormap representation
% 
% figure('Name','Surface Plot of the population (corrected traces)','NumberTitle','off','Color',[1 1 1])
% surf(frames,cellname,corrnormtimetracest);
% hold on
% imagesc(corrnormtimetracest);
% title('MFI/MFI_{0} of single cells, surface plot','FontSize',18,'FontName','Optima');
% xlabel('Frames','FontSize',18,'FontName','Optima');
% ylabel('Stack of single cells responses','FontSize',18,'FontName','Optima');
% %ylim([0 ncell]);
% %xlim([0 frames]);

%% THRESHOLD AND SUBSEQUENT SUBPLOT SELECTION

%%% Defines responders based on a manually selected threshold and plots their traces

close all
[responders,responderstraces] = thresholdfunction(corrtimetraces,celllabel,xaxis);
pause

%%% Allows you to select the traces to continue analysis with

close all
[respondersselected,responderstrashed,responderstimetracesselected,responderstimetracestrashed]= cellselectionfunction(xaxis,responderstraces,responders);

respondersALL = responders;
responderstracesALL = responderstraces;
clearvars responders responderstraces;
responders = respondersselected;
responderstraces = responderstimetracesselected;
clearvars respondersselected responderstimetracesselected;

%%% Plot selected cells' time traces and heatmap

plotheatmapfunction('Selected cells (threshold method)','Selected cells, heatmap (threshold method)','Time (s)','MFI','Frames','Stack of responders',responderstraces,xaxis);

pause
close all
%% SLOPE AND SUBSEQUENT SUBPLOT SELECTION
%%% Defines responders based on a manually selected threshold and plots their traces

close all
[sloperesponders,sloperesponderstraces] = slopefunction(corrtimetraces,celllabel,xaxis);
pause

%%% Allows you to select the traces to continue analysis with

close all
[sloperespondersselected,sloperesponderstrashed,sloperesponderstimetracesselected,sloperesponderstimetracestrashed]= cellselectionfunction(xaxis,sloperesponderstraces,sloperesponders);

sloperespondersALL = sloperesponders;
sloperesponderstracesALL = sloperesponderstraces;
clearvars sloperesponders sloperesponderstraces;
sloperesponders = sloperespondersselected;
sloperesponderstraces = sloperesponderstimetracesselected;
clearvars sloperespondersselected sloperesponderstimetracesselected;

%%% Plot selected cells' time traces and heatmap

plotheatmapfunction('Selected cells (slope method)','Selected cells, heatmap (slope method)','Time (s)','MFI','Frames','Stack of responders',sloperesponderstraces,xaxis);

pause
close all